//
//  OPItemSpecifier.h
//  ApplicationFrameworks
//
//  Created by Chad Seldomridge on 10/1/15.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordDataModel/OnePasswordDataModel.h>

@interface OPItemSpecifier : NSObject <NSSecureCoding, NSCopying>

+ (instancetype)specifierWithItem:(OPItem *)item;
- (instancetype)initWithItem:(OPItem *)item;
- (instancetype)initWithUUID:(NSString *)uuid profileUUID:(NSString *)profileUUID;

@property (nonatomic, readonly, copy) NSString *uuid;
@property (nonatomic, readonly, copy) NSString *profileUUID;

// Utility
- (BOOL)matchesItem:(OPItem *)item;
+ (void)iterateOverProfilesInSpecifiers:(NSArray *)specifiers withBlock:(void (^)(NSString *profileUUID, NSArray *itemUUIDs))block;

@end
